﻿<%@ import Namespace="System.Globalization" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zaświadczenie o zatrudnieniu</title>
		
		<script runat="server">

        public class SrParams : SerializableContextBase {
            public SrParams(Context context) : base(context) {
            }

            bool pelneStanowisko = false;
            [Priority(1)]
            [Caption("Stanowisko pełna nazwa")]
            public bool PelneStanowisko {
                get { return pelneStanowisko; }
                set {
                    pelneStanowisko = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            bool historiaZatr = false;
            [Priority(2)]
            [Caption("Historia zatrudnienia")]
            public bool HistoriaZatr {
                get { return historiaZatr; }
                set {
                    historiaZatr = value;
                    OnChanged(EventArgs.Empty);
                }
            }

        }

        SrParams srpars;
        [SettingsContext]
        public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }		
      
        void dc_ContextLoad(Object sender, EventArgs e) {
            PracHistoria historia = (PracHistoria)dc[typeof(PracHistoria)];
            ReportHeader1["MIEJSCOWOSC"] = GetMiejscowosc(historia);
            DaneFirmy(historia);

            string hz = "";
            if (srpars.HistoriaZatr) {
                StatystykaZatrudnieniaWorker szw = new StatystykaZatrudnieniaWorker();
                szw.Pracownik = historia.Pracownik;

                Date prev = Date.MinValue;
                foreach (PracHistoria ph in szw.UmowyOPracę) {
                    if (prev < ph.Etat.OkresUmowy.From.AddDays(-1))
                        hz = "";
                    if (ph.Etat.OkresUmowy.To == Date.MaxValue)
                        hz += string.Format("{0} od <strong>{1}</strong> na stanowisku: <strong>{2}</strong>, w wymiarze: <strong>{3}</strong><br/>",
                            CaptionAttribute.EnumToString(ph.Etat.TypUmowy),
                            ph.Etat.OkresUmowy.From,
                            GetStanowisko(ph),
                            ph.Etat.Wymiar);
                    else
                        hz += string.Format("{0} od <strong>{1}</strong> do <strong>{2}</strong> na stanowisku: <strong>{3}, w wymiarze: <strong>{4}</strong><br/>",
                            CaptionAttribute.EnumToString(ph.Etat.TypUmowy),
                            ph.Etat.OkresUmowy.From,
                            ph.Etat.OkresUmowy.To,
                            GetStanowisko(ph),
                            ph.Etat.Wymiar);
                    prev = ph.Etat.OkresUmowy.To;
                }
            }
            else {
                if (historia.Etat.OkresZatrudnienia.To == Date.MaxValue)
                    hz = string.Format("{0} od <strong>{1}</strong> na stanowisku: <strong>{2}</strong>, w wymiarze: <strong>{3}</strong><br/>",
                        CaptionAttribute.EnumToString(historia.Etat.TypUmowy),
                        historia.Etat.OkresZatrudnienia.From,
                        GetStanowisko(historia),
                        historia.Etat.Wymiar);
                else
                    hz = string.Format("{0} od <strong>{1}</strong> do <strong>{2}</strong> na stanowisku: <strong>{3}</strong>, w wymiarze: <strong>{4}</strong><br/>",
                        CaptionAttribute.EnumToString(historia.Etat.TypUmowy),
                        historia.Etat.OkresZatrudnienia.From,
                        historia.Etat.OkresZatrudnienia.To,
                        GetStanowisko(historia),
                        historia.Etat.Wymiar);
            }            
            HistoriaZatr.EditValue = hz;
        }

        string GetStanowisko(PracHistoria ph) {
            string stanowiskoPelne = "";
            if (srpars.PelneStanowisko)
                stanowiskoPelne = ph.Etat.StanowiskoPełne;
            if (stanowiskoPelne.Length == 0)
                stanowiskoPelne = ph.Etat.Stanowisko;
            return stanowiskoPelne;
        }

        string GetMiejscowosc(PracHistoria ph) {
            CoreModule core = CoreModule.GetInstance(dc);
            string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
            if (miejscowosc.Length == 0)
                miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
            if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
                OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
            }                
            return miejscowosc;
        }
                
        void DaneFirmy(PracHistoria ph) {
            CoreModule core = CoreModule.GetInstance(dc);
            string nazwa = core.Config.Firma.Pieczątka.Nazwa;
            if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
                OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                if (!string.IsNullOrEmpty(of.Nazwa)) nazwa = of.Nazwa;
            }
            PieczątkaNazwa.EditValue = nazwa;
        }

        </script>
		<META http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	    <style type="text/css">
            .style1
            {
                font-family: Tahoma;
                font-size: small;
            }
        </style>
	</HEAD>
	<body>
		<form id="ZaświadczenieOZatrudnieniu" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" 
                TypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" 
                oncontextload="dc_ContextLoad"></ea:datacontext>
			<p>
				<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="ZAŚWIADCZENIE O ZATRUDNIENIU|%MIEJSCOWOSC%, {0}" runat="server"
					DataMember0="Context.ActualDate.Actual"></cc1:ReportHeader>
			</p>
			<p>
				<table id="Table1" cellspacing="0" width="100%">
					<tbody>
						<tr>
							<td class="style1">
								Zaświadcza się, że
								<ea:DataLabel id="DataLabel13" runat="server" Bold="False" DataMember="Plec">
									<ValuesMap>
										<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
										<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
									</ValuesMap>
								</ea:DataLabel>
							</td>
							<td class="style1">
								<ea:DataLabel id="DataLabel1" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:DataLabel>
							</td>
						</tr>
						<tr>
							<td class="style1">
				                <ea:DataLabel id="DataLabel10" runat="server" Bold="False" DataMember="Plec">
					                <ValuesMap>
						                <ea:ValuesPair Key="Kobieta" Value="zamieszkała"></ea:ValuesPair>
						                <ea:ValuesPair Key="Mężczyzna" Value="zamieszkały"></ea:ValuesPair>
					                </ValuesMap>
				                </ea:DataLabel>
                                <br>
							</td>
							<td class="style1">
								<ea:DataLabel id="DataLabel2" runat="server" DataMember="Adres.Linia1"></ea:DataLabel>
								<ea:DataLabel id="DataLabel6" runat="server" DataMember="Adres.Linia2"></ea:DataLabel>
							</td>
						</tr>
						<tr>
							<td class="style1">
								data urodzenia
							</td>
							<td class="style1">
								<ea:DataLabel id="DataLabel4" runat="server" DataMember="Urodzony.Data"></ea:DataLabel>
							</td>
						</tr>
						<tr>
							<td class="style1">
								PESEL
							</td>
							<td class="style1">
								<ea:DataLabel id="DataLabel5" runat="server" DataMember="PESEL"></ea:DataLabel>
							</td>
						</tr>
					</tbody>
				</table>
			</p>
			<p class="style1">
				<ea:DataLabel id="DataLabel8" runat="server" Bold="False" DataMember="Plec">
					<ValuesMap>
						<ea:ValuesPair Key="Kobieta" Value="zatrudniona"></ea:ValuesPair>
						<ea:ValuesPair Key="Mężczyzna" Value="zatrudniony"></ea:ValuesPair>
					</ValuesMap>
				</ea:DataLabel>
				jest w zakładzie<br/>
				<ea:DataLabel id="PieczątkaNazwa" runat="server"></ea:DataLabel>
			    <br/><br/>
                <ea:DataLabel id="HistoriaZatr" runat="server" Bold="False"></ea:DataLabel>

				<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False">
					<Subtitles>
						<cc1:FooterSubtitle SubtitleType="Empty" Width="50"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="podpis osoby wystawiającej zaświadczenie" Width="50"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter>
			</p>
		</form>
	</body>
</HTML>
